//FloorMountingPostGaps.scad;

//Use FloorMountingPostGap four times 
//to generate four mounting post gaps;

//FloorMountingPostGap generates one 
//mounting post gap centered at the origin 
//and the XY plane;
//It will extend FloorZ/2 below the XY plane 
//and FloorZ/2 above it;
//When translated by DeltaZ = FloorZ,
//it will make a gap Floor/2 into the top 
//of the floor;
    
//On exit from this module, 
//each gap is a small cylinder;
//It doesn't become a gap until it is used 
//as the second argument of a 
//difference() command;

//The gaps are all the same size;

include <BATT_Dimensions.scad>
use <BATT_FloorMountingPostGap.scad>;

module FloorMountingPostGaps()
{

echo("Begin FloorMountingPostGaps");
    
//DeltaZ is constant for all mounting posts;
DeltaZ = FloorZ;

//All six mounting posts need a gap;
//echo("Post1 = ", Post1x, Post1y);
translate([Post1x, Post1y, DeltaZ])
    FloorMountingPostGap();

//echo("Post2 = ", Post2x, Post2y);
translate([Post2x, Post2y, DeltaZ])
    FloorMountingPostGap();

//echo("Post3 = ", Post3x, Post3y);
translate([Post3x, Post3y, DeltaZ])
    FloorMountingPostGap();

//echo("Post4 = ", Post4x, Post4y);
translate([Post4x, Post4y, DeltaZ])
    FloorMountingPostGap();

//echo("Post5 = ", Post5x, Post5y);
translate([Post5x, Post5y, DeltaZ])
    FloorMountingPostGap();

//echo("Post6 = ", Post6x, Post6y);
translate([Post6x, Post6y, DeltaZ])
    FloorMountingPostGap();

}
//
